# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdvalue import *
from .sdapiobject import *
from .sdapiobject import *
from .apiexception import APIException

class SDValueSerializer(SDAPIObject):
    """
    A set of helper functions for serialization and deserialization of SDValue
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValueSerializer
        """
        super(SDValueSerializer, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sToString(sdValue : SDValue) -> str:
        """
        Convert the specified value to string

        :param sdValue: The concrete value
        """
        outString = ctypes.c_char_p()
        _res = sd.getContext().SDValueSerializer_sToString(sdValue.mHandle, ctypes.byref(outString))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outString.value.decode('utf-8') # type: ignore

